<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="About Nitisha Data Recovery - Leading data recovery experts in Hyderabad with 16+ years experience and 98% success rate.">
    <meta name="keywords" content="about data recovery, data recovery company hyderabad, data recovery experts, professional data recovery team">
    <title>About Us - Nitisha Data Recovery | Data Recovery Experts in Hyderabad</title>
    <link rel="canonical" href="https://nitishadata.com/about.php">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>About Nitisha Data Recovery</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">About</li>
                </ol>
            </nav>
        </div>
    </section>

    <!-- About Content -->
    <section class="about-content">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h2>Leading Data Recovery Experts in Hyderabad</h2>
                    <p class="lead">Nitisha Data Recovery has established itself as the premier data recovery service provider in Hyderabad with over 16 years of experience in the industry.</p>

                    <p>Since our inception, we have successfully recovered data for thousands of clients, ranging from individual consumers to large enterprises. Our state-of-the-art laboratory is equipped with the latest data recovery tools and clean room facilities.</p>

                    <h3>Our Mission</h3>
                    <p>To provide reliable, secure, and efficient data recovery services while maintaining the highest standards of data confidentiality and customer satisfaction.</p>

                    <h3>Our Vision</h3>
                    <p>To become the most trusted name in data recovery services across India, known for our technical excellence and customer-centric approach.</p>
                </div>

                <div class="col-md-6">
                    <img src="images/about-lab.jpg" alt="Data Recovery Laboratory" class="img-fluid rounded">
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="team-section">
        <div class="container">
            <h2>Our Expert Team</h2>
            <p class="section-subtitle">Meet our certified data recovery specialists</p>

            <div class="team-grid">
                <div class="team-member">
                    <img src="images/team-lead.jpg" alt="Senior Data Recovery Specialist">
                    <h3>Technical Lead</h3>
                    <p>Senior Data Recovery Specialist</p>
                    <p>16+ years of experience in complex data recovery cases</p>
                </div>

                <div class="team-member">
                    <img src="images/hardware-expert.jpg" alt="Hardware Recovery Expert">
                    <h3>Hardware Expert</h3>
                    <p>Physical Damage Recovery Specialist</p>
                    <p>Expert in clean room recovery and hardware repair</p>
                </div>

                <div class="team-member">
                    <img src="images/software-expert.jpg" alt="Software Recovery Expert">
                    <h3>Software Expert</h3>
                    <p>Logical Recovery Specialist</p>
                    <p>Specialist in file system recovery and data reconstruction</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Certifications -->
    <section class="certifications">
        <div class="container">
            <h2>Certifications & Standards</h2>
            <div class="cert-grid">
                <div class="cert-item">
                    <i class="fas fa-certificate"></i>
                    <h3>ISO 9001:2015</h3>
                    <p>Quality Management System</p>
                </div>

                <div class="cert-item">
                    <i class="fas fa-shield-alt"></i>
                    <h3>ISO 27001</h3>
                    <p>Information Security Management</p>
                </div>

                <div class="cert-item">
                    <i class="fas fa-user-graduate"></i>
                    <h3>Certified Technicians</h3>
                    <p>Industry certified recovery specialists</p>
                </div>

                <div class="cert-item">
                    <i class="fas fa-microscope"></i>
                    <h3>Clean Room Facility</h3>
                    <p>Class 100 clean room standards</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Statistics -->
    <section class="statistics">
        <div class="container">
            <h2>Our Track Record</h2>
            <div class="stats-grid">
                <div class="stat-item">
                    <div class="stat-number">10,000+</div>
                    <div class="stat-label">Successful Recoveries</div>
                </div>

                <div class="stat-item">
                    <div class="stat-number">98%</div>
                    <div class="stat-label">Success Rate</div>
                </div>

                <div class="stat-item">
                    <div class="stat-number">16+</div>
                    <div class="stat-label">Years Experience</div>
                </div>

                <div class="stat-item">
                    <div class="stat-number">24/7</div>
                    <div class="stat-label">Support Available</div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="main.js"></script>
</body>
</html>