<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Thank you for contacting Nitisha Data Recovery. We will get back to you soon with data recovery consultation.">
    <title>Thank You - Nitisha Data Recovery</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <section class="thank-you-section">
        <div class="container">
            <div class="thank-you-content">
                <i class="fas fa-check-circle success-icon"></i>
                <h1>Thank You!</h1>
                <p class="lead">Your inquiry has been received successfully. Our data recovery experts will contact you within 24 hours.</p>

                <div class="next-steps">
                    <h2>What happens next?</h2>
                    <div class="steps">
                        <div class="step">
                            <i class="fas fa-phone"></i>
                            <h3>We'll Call You</h3>
                            <p>Our expert will contact you to discuss your data recovery needs</p>
                        </div>

                        <div class="step">
                            <i class="fas fa-clipboard-check"></i>
                            <h3>Free Evaluation</h3>
                            <p>Bring your device for free diagnosis and recovery assessment</p>
                        </div>

                        <div class="step">
                            <i class="fas fa-tools"></i>
                            <h3>Recovery Process</h3>
                            <p>We'll start the recovery process after your approval</p>
                        </div>
                    </div>
                </div>

                <div class="urgent-contact">
                    <p><strong>Need immediate assistance?</strong></p>
                    <a href="tel:+919640524040" class="btn-primary">
                        <i class="fas fa-phone"></i> Call Now: 9640524040
                    </a>
                </div>

                <div class="return-links">
                    <a href="index.php" class="btn-secondary">Return to Home</a>
                    <a href="services.php" class="btn-secondary">View Our Services</a>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="main.js"></script>
</body>
</html>