# Nitisha Data Recovery Website

Professional data recovery services website built with flat PHP.

## About

This is a complete website for Nitisha Data Recovery, a professional data recovery service provider in Hyderabad with over 16 years of experience. The website showcases services, pricing, company information, and contact details.

## Features

- **Responsive Design**: Mobile-friendly layout that works on all devices
- **Multiple Pages**: Home, Services, Pricing, About, Contact
- **SEO Optimized**: Meta tags and keywords for better search engine visibility
- **Contact Form**: Functional PHP contact form with validation
- **Clean Code**: Well-structured PHP, HTML, CSS, and JavaScript
- **Modern UI**: Beautiful gradient design with Font Awesome icons

## Pages

1. **index.php** - Home page with hero section, services overview, and facility showcase
2. **services.php** - Detailed service descriptions for all recovery types
3. **pricing.php** - Transparent pricing plans and factors affecting cost
4. **about.php** - Company information, expertise, and team details
5. **contact.php** - Contact form, information, and map

## File Structure

```
nitisha-data-recovery/
├── index.php
├── services.php
├── pricing.php
├── about.php
├── contact.php
├── process_contact.php
├── includes/
│   ├── header.php
│   └── footer.php
├── css/
│   └── style.css
├── js/
│   └── script.js
├── images/
│   ├── My-Profile.jpg
│   ├── exterier-image.jpg
│   └── (add more images from Unsplash)
└── README.md
```

## Installation

1. **Upload Files**: Upload all files to your web server
2. **Configure Email**: Edit `process_contact.php` and update the email address
3. **Add Images**: Place your images in the `images/` folder
4. **Test**: Access the website through your domain

## Requirements

- PHP 7.0 or higher
- Web server (Apache/Nginx)
- Mail function enabled for contact form

## Configuration

### Email Setup
Edit `process_contact.php` line 18:
```php
$to = "info@nitishadata.com"; // Change to your email
```

### Social Media Links
Edit `includes/header.php` and `includes/footer.php` to add your social media URLs.

### Google Maps
Edit `contact.php` to update the Google Maps embed with your exact location coordinates.

## Images

The website uses two provided images:
- `My-Profile.jpg` - Expert profile photo
- `exterier-image.jpg` - Shop exterior photo

You can add more images from Unsplash for better visual appeal:
- Hero background image
- Service-related images
- Technology/lab images

## SEO Keywords

The website is optimized for these keywords:
- Data Recovery
- Hard Drive Recovery
- SSD Recovery
- Laptop Data Recovery
- RAID Recovery
- Server Data Recovery
- Data Recovery Hyderabad
- Data Recovery Secunderabad

## Contact Information

**Business Name**: Nitisha Data Recovery
**Phone**: +91 9640524040
**Email**: info@nitishadata.com
**Address**: No 181, 1st Floor, C Block Building, Near Pal Lane, Paradise, Panjagutta, Secunderabad, Telangana
**Hours**: Mon-Sat: 10:30 AM - 7:00 PM, Emergency: 24/7

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers

## Credits

**Designed by**: Hyderabad Graphics
**Website**: https://hyderabadgraphics.com
**Developer**: Your Name

## License

Copyright © 2025 Nitisha Data Recovery. All Rights Reserved.

## Support

For any issues or customization requests, contact Hyderabad Graphics.
