<?php $page_title = "Home"; ?>
<?php include 'includes/header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="hero-overlay"></div>
        <div class="container">
            <div class="hero-content">
                <h1>Professional Data Recovery Services in Hyderabad</h1>
                <p class="hero-subtitle">Expert data recovery with 98% success rate. We recover data from hard disks, laptops, SSDs, servers, and RAID systems.</p>
                <p class="hero-experience">Over 16+ years of experience with advanced recovery techniques</p>
                <div class="hero-features">
                    <div class="feature-badge">
                        <i class="fas fa-check-circle"></i>
                        <span>98% Success Rate</span>
                    </div>
                    <div class="feature-badge">
                        <i class="fas fa-clock"></i>
                        <span>Quick Service</span>
                    </div>
                    <div class="feature-badge">
                        <i class="fas fa-shield-alt"></i>
                        <span>Data Confidentiality</span>
                    </div>
                </div>
                <a href="tel:9640524040" class="hero-cta">Call Now: 9640524040</a>
            </div>
        </div>
    </section>

    <!-- Profile Section -->
    <section class="profile-section">
        <div class="container">
            <div class="profile-content">
                <div class="profile-image">
                    <img src="images/My-Profile.jpg" alt="Data Recovery Expert">
                </div>
                <div class="profile-text">
                    <h2>Expert Data Recovery Specialist</h2>
                    <p>With over 16 years of experience in data recovery, we have successfully recovered data from thousands of devices. Our state-of-the-art clean room facility and advanced recovery techniques ensure the highest success rate in the industry.</p>
                    <p>We understand how valuable your data is, whether it's precious family photos, critical business documents, or important project files. Our team works tirelessly to recover your data safely and securely.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Overview Section -->
    <section class="services-overview">
        <div class="container">
            <div class="section-header">
                <h2>Our Data Recovery Services</h2>
                <p>Comprehensive data recovery solutions for all types of storage devices</p>
            </div>

            <div class="services-grid">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-hdd"></i>
                    </div>
                    <h3>Hard Disk Recovery</h3>
                    <p>Professional recovery from internal and external hard drives including Seagate, WD, Samsung, Maxtor, and Toshiba drives.</p>
                    <ul>
                        <li>Desktop HDD Recovery</li>
                        <li>Laptop HDD Recovery</li>
                        <li>External HDD Recovery</li>
                        <li>SSD Recovery</li>
                    </ul>
                    <a href="services.php#hard-disk-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>

                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-laptop"></i>
                    </div>
                    <h3>Laptop Data Recovery</h3>
                    <p>Specialized recovery services for all laptop brands and models including damaged, crashed, or corrupted laptops.</p>
                    <ul>
                        <li>Crashed Laptop Recovery</li>
                        <li>Water Damaged Laptops</li>
                        <li>Boot Failure Recovery</li>
                        <li>Virus Infected Systems</li>
                    </ul>
                    <a href="services.php#laptop-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>

                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-memory"></i>
                    </div>
                    <h3>Memory Card Recovery</h3>
                    <p>Recovery from smartphones, tablets, SD cards, micro SD cards, and other portable storage devices.</p>
                    <ul>
                        <li>Android Memory Card Recovery</li>
                        <li>iPhone Memory Card  Recovery</li>
                        <li>SD Card Recovery</li>
                        <li>USB Drive Recovery</li>
                    </ul>
                    <a href="services.php#memory-card-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>

                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-server"></i>
                    </div>
                    <h3>RAID & Server Recovery</h3>
                    <p>Complex RAID configurations and server data recovery with specialized equipment and expertise.</p>
                    <ul>
                        <li>RAID 0, 1, 5, 6, 10</li>
                        <li>NAS Recovery</li>
                        <li>Server Data Recovery</li>
                        <li>Database Recovery</li>
                    </ul>
                    <a href="services.php#raid-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>

                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h3>Specialized Recovery</h3>
                    <p>Advanced recovery techniques for complex data loss scenarios including physical damage and corruption.</p>
                    <ul>
                        <li>Physical Damage Recovery</li>
                        <li>Fire & Water Damage</li>
                        <li>Encrypted Drive Recovery</li>
                        <li>Forensic Recovery</li>
                    </ul>
                    <a href="services.php#specialized-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>

                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-microchip"></i>
                    </div>
                    <h3>SSD NVMe Recovery</h3>
                    <p>Advanced recovery services for modern SSDs and NVMe drives with cutting-edge technology.</p>
                    <ul>
                        <li>SATA SSD Recovery</li>
                        <li>NVMe M.2 Recovery</li>
                        <li>PCIe SSD Recovery</li>
                        <li>Flash Memory Recovery</li>
                    </ul>
                    <a href="services.php#ssd-recovery" class="service-link">Learn More <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </section>

    <!-- Facility Section -->
    <section class="facility-section">
        <div class="container">
            <div class="facility-content">
                <div class="facility-image">
                    <img src="images/exterier-image.jpg" alt="Nitisha Data Recovery Shop">
                </div>
                <div class="facility-text">
                    <h2>Our Professional Facility</h2>
                    <p><strong>Nitisha Data Recovery Shop</strong></p>
                    <p>Located at <strong>No 181, 1st Floor, C Block Building, Near Pal Lane, Paradise, Panjagutta, Secunderabad</strong></p>
                    <p><strong>Timings:</strong> Monday to Saturday: 10:30 AM to 7:00 PM | Sunday: Closed</p>
                    <p><strong>Emergency Services:</strong> Available 24/7 for critical data recovery needs</p>
                    <p>Our state-of-the-art facility features advanced clean room technology, specialized recovery equipment, and a secure environment for handling your sensitive data.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="why-choose-us">
        <div class="container">
            <div class="section-header">
                <h2>Why Choose Nitisha Data Recovery?</h2>
                <p>Your trusted partner for professional data recovery services in Hyderabad</p>
            </div>

            <div class="features-grid">
                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-award"></i>
                    </div>
                    <h3>16+ Years Experience</h3>
                    <p>Over 16 years of expertise in data recovery with thousands of successful recoveries.</p>
                </div>

                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-microscope"></i>
                    </div>
                    <h3>Advanced Equipment</h3>
                    <p>State-of-the-art data recovery lab with latest tools and clean room facilities.</p>
                </div>

                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <h3>Data Confidentiality</h3>
                    <p>100% data privacy and confidentiality guaranteed. Your data remains secure.</p>
                </div>

                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3>No Recovery, No Fee</h3>
                    <p>Pay only after successful data recovery. Free diagnosis and evaluation.</p>
                </div>

                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-tachometer-alt"></i>
                    </div>
                    <h3>Quick Turnaround</h3>
                    <p>Fast recovery services with most cases completed within 24-48 hours.</p>
                </div>

                <div class="feature-box">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3>24/7 Support</h3>
                    <p>Round-the-clock customer support for emergency data recovery needs.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Recovery Process Section -->
    <section class="recovery-process">
        <div class="container">
            <div class="section-header">
                <h2>Our Data Recovery Process</h2>
                <p>Simple and transparent process to get your data back</p>
            </div>

            <div class="process-steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Free Evaluation</h3>
                        <p>Bring your device for free diagnosis. We assess the damage and provide recovery estimate.</p>
                    </div>
                </div>

                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>Recovery Process</h3>
                        <p>Our experts use advanced techniques and equipment to safely recover your data.</p>
                    </div>
                </div>

                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>Data Verification</h3>
                        <p>We verify and test the recovered data to ensure completeness and integrity.</p>
                    </div>
                </div>

                <div class="step">
                    <div class="step-number">4</div>
                    <div class="step-content">
                        <h3>Data Delivery</h3>
                        <p>Your recovered data is securely transferred to a new storage device.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Need Data Recovery Services?</h2>
                <p>Contact us now for free diagnosis and evaluation. Available 24/7 for emergency recovery.</p>
                <div class="cta-buttons">
                    <a href="tel:9640524040" class="btn-primary">Call Now: 9640524040</a>
                    <a href="contact.php" class="btn-secondary">Contact Us</a>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>