<?php $page_title = "Pricing"; ?>
<?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Transparent Pricing</h1>
            <p>Affordable data recovery services with no hidden charges</p>
        </div>
    </section>

    <!-- Pricing Section -->
    <section class="pricing-section">
        <div class="container">
            <div class="section-intro">
                <h2>Our Pricing Plans</h2>
                <p>Pricing varies based on storage size, damage type, and urgency. Contact us for accurate quote.</p>
            </div>

            <div class="pricing-grid">
                <!-- Basic Recovery -->
                <div class="pricing-card">
                    <div class="pricing-header">
                        <h3>Basic Recovery</h3>
                        <div class="price">
                            <span class="currency">₹</span>
                            <span class="amount">2,000</span>
                            <span class="period">+</span>
                        </div>
                    </div>
                    <div class="pricing-features">
                        <ul>
                            <li><i class="fas fa-check"></i> Logical data recovery</li>
                            <li><i class="fas fa-check"></i> Deleted file recovery</li>
                            <li><i class="fas fa-check"></i> Format recovery</li>
                            <li><i class="fas fa-check"></i> Basic diagnosis</li>
                            <li><i class="fas fa-check"></i> Standard turnaround</li>
                            <li><i class="fas fa-check"></i> Email support</li>
                        </ul>
                    </div>
                    <a href="contact.php" class="pricing-btn">Get Started</a>
                </div>

                <!-- Advanced Recovery -->
                <div class="pricing-card featured">
                    <div class="popular-badge">Most Popular</div>
                    <div class="pricing-header">
                        <h3>Advanced Recovery</h3>
                        <div class="price">
                            <span class="currency">₹</span>
                            <span class="amount">5,000</span>
                            <span class="period">+</span>
                        </div>
                    </div>
                    <div class="pricing-features">
                        <ul>
                            <li><i class="fas fa-check"></i> Physical damage recovery</li>
                            <li><i class="fas fa-check"></i> RAID recovery</li>
                            <li><i class="fas fa-check"></i> Server data recovery</li>
                            <li><i class="fas fa-check"></i> Clean room recovery</li>
                            <li><i class="fas fa-check"></i> Priority service</li>
                            <li><i class="fas fa-check"></i> 24/7 support</li>
                        </ul>
                    </div>
                    <a href="contact.php" class="pricing-btn">Get Started</a>
                </div>

                <!-- Enterprise Recovery -->
                <div class="pricing-card">
                    <div class="pricing-header">
                        <h3>Enterprise Recovery</h3>
                        <div class="price">
                            <span class="amount-text">Contact Us</span>
                        </div>
                    </div>
                    <div class="pricing-features">
                        <ul>
                            <li><i class="fas fa-check"></i> Critical business data</li>
                            <li><i class="fas fa-check"></i> 24/7 priority support</li>
                            <li><i class="fas fa-check"></i> On-site recovery</li>
                            <li><i class="fas fa-check"></i> Forensic recovery</li>
                            <li><i class="fas fa-check"></i> Emergency service</li>
                            <li><i class="fas fa-check"></i> Dedicated specialist</li>
                        </ul>
                    </div>
                    <a href="contact.php" class="pricing-btn">Contact Us</a>
                </div>
            </div>

            <div class="pricing-note">
                <p><strong>Note:</strong> Pricing varies based on storage size, damage type, and urgency. Contact us for accurate quote. We offer <strong>FREE diagnosis and evaluation</strong> for all devices.</p>
            </div>
        </div>
    </section>

    <!-- Pricing Factors Section -->
    <section class="pricing-factors">
        <div class="container">
            <h2>Factors Affecting Data Recovery Cost</h2>
            <div class="factors-grid">
                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-hdd"></i>
                    </div>
                    <h3>Storage Capacity</h3>
                    <p>Larger drives require more time and resources to recover, affecting the overall cost.</p>
                </div>

                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h3>Damage Severity</h3>
                    <p>Physical damage, water damage, or fire damage require specialized clean room recovery.</p>
                </div>

                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>Urgency Level</h3>
                    <p>Emergency or rush services cost more due to priority processing and dedicated resources.</p>
                </div>

                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-microchip"></i>
                    </div>
                    <h3>Storage Type</h3>
                    <p>SSDs, NVMe drives, and RAID systems require specialized techniques and equipment.</p>
                </div>

                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <h3>Recovery Complexity</h3>
                    <p>Complex recoveries involving multiple failures or encryption require more expertise.</p>
                </div>

                <div class="factor-card">
                    <div class="factor-icon">
                        <i class="fas fa-database"></i>
                    </div>
                    <h3>Data Volume</h3>
                    <p>Amount of data to be recovered affects processing time and verification procedures.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- No Recovery No Fee -->
    <section class="no-fee-guarantee">
        <div class="container">
            <div class="guarantee-content">
                <div class="guarantee-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <div class="guarantee-text">
                    <h2>No Recovery, No Fee Guarantee</h2>
                    <p>We believe in transparent pricing and customer satisfaction. You only pay when we successfully recover your data. Free diagnosis and evaluation for all devices.</p>
                    <ul>
                        <li><i class="fas fa-check"></i> Free diagnosis and evaluation</li>
                        <li><i class="fas fa-check"></i> Pay only after successful recovery</li>
                        <li><i class="fas fa-check"></i> No hidden charges</li>
                        <li><i class="fas fa-check"></i> Transparent pricing</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Get a Free Quote Today</h2>
                <p>Contact us for free diagnosis and accurate pricing for your data recovery needs.</p>
                <div class="cta-buttons">
                    <a href="tel:9640524040" class="btn-primary">Call: 9640524040</a>
                    <a href="contact.php" class="btn-secondary">Request Quote</a>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>