<?php
// Process Contact Form Submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $name = htmlspecialchars(trim($_POST['name']));
    $email = htmlspecialchars(trim($_POST['email']));
    $phone = htmlspecialchars(trim($_POST['phone']));
    $device_type = htmlspecialchars(trim($_POST['device_type']));
    $message = htmlspecialchars(trim($_POST['message']));

    // Validate required fields
    if (empty($name) || empty($email) || empty($phone) || empty($message)) {
        header("Location: contact.php?error=Please fill all required fields");
        exit();
    }

    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header("Location: contact.php?error=Invalid email address");
        exit();
    }

    // Email configuration
    $to = "info@nitishadata.com";
    $subject = "New Contact Form Submission - Nitisha Data Recovery";

    // Email body
    $email_body = "New contact form submission from Nitisha Data Recovery website:\n\n";
    $email_body .= "Name: " . $name . "\n";
    $email_body .= "Email: " . $email . "\n";
    $email_body .= "Phone: " . $phone . "\n";
    $email_body .= "Device Type: " . ($device_type ? $device_type : "Not specified") . "\n";
    $email_body .= "Message:\n" . $message . "\n";

    // Email headers
    $headers = "From: " . $email . "\r\n";
    $headers .= "Reply-To: " . $email . "\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send email
    if (mail($to, $subject, $email_body, $headers)) {
        // Redirect to thank you page or contact page with success message
        header("Location: contact.php?success=Thank you for contacting us. We will get back to you soon.");
        exit();
    } else {
        // Redirect with error message
        header("Location: contact.php?error=Sorry, there was an error sending your message. Please try again or call us directly.");
        exit();
    }
} else {
    // If accessed directly, redirect to contact page
    header("Location: contact.php");
    exit();
}
?>