<?php $page_title = "Services"; ?>
<?php include 'includes/header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Our Data Recovery Services</h1>
            <p>Comprehensive data recovery solutions for all types of storage devices and data loss scenarios</p>
        </div>
    </section>

    <!-- Services Detail Section -->
    <section class="services-detail">
        <div class="container">

            <!-- Hard Disk Recovery -->
            <div id="hard-disk-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-hdd"></i>
                    </div>
                    <div>
                        <h2>Hard Disk Recovery</h2>
                        <p>Professional recovery from internal and external hard drives</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>We specialize in recovering data from all types of hard disk drives including Seagate, WD (Western Digital), Samsung, Maxtor, Toshiba, Hitachi, and other major brands. Whether your hard drive has suffered physical damage, logical corruption, or mechanical failure, our experts can help.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>Recovery Services Include:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Desktop HDD Recovery</li>
                                <li><i class="fas fa-check"></i> Laptop HDD Recovery</li>
                                <li><i class="fas fa-check"></i> External HDD Recovery</li>
                                <li><i class="fas fa-check"></i> Portable HDD Recovery</li>
                                <li><i class="fas fa-check"></i> SATA HDD Recovery</li>
                                <li><i class="fas fa-check"></i> IDE HDD Recovery</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>Common Issues We Solve:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Clicking or beeping sounds</li>
                                <li><i class="fas fa-check"></i> Drive not detected</li>
                                <li><i class="fas fa-check"></i> Corrupted file system</li>
                                <li><i class="fas fa-check"></i> Formatted drive recovery</li>
                                <li><i class="fas fa-check"></i> Accidental deletion</li>
                                <li><i class="fas fa-check"></i> Physical damage recovery</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Laptop Data Recovery -->
            <div id="laptop-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-laptop"></i>
                    </div>
                    <div>
                        <h2>Laptop Data Recovery</h2>
                        <p>Expert recovery services for all laptop brands and models</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>Specialized data recovery services for laptops of all major brands including Dell, HP, Lenovo, Asus, Acer, Apple MacBook, MSI, and others. We handle all types of laptop data loss scenarios from simple software issues to complex hardware failures.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>Recovery Services Include:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Crashed Laptop Recovery</li>
                                <li><i class="fas fa-check"></i> Water Damaged Laptops</li>
                                <li><i class="fas fa-check"></i> Boot Failure Recovery</li>
                                <li><i class="fas fa-check"></i> Virus Infected Systems</li>
                                <li><i class="fas fa-check"></i> Dead Laptop Recovery</li>
                                <li><i class="fas fa-check"></i> MacBook Data Recovery</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>Laptop Brands We Support:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Dell Laptops</li>
                                <li><i class="fas fa-check"></i> HP Laptops</li>
                                <li><i class="fas fa-check"></i> Lenovo Laptops</li>
                                <li><i class="fas fa-check"></i> Apple MacBook</li>
                                <li><i class="fas fa-check"></i> Asus Laptops</li>
                                <li><i class="fas fa-check"></i> All Other Brands</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SSD & NVMe Recovery -->
            <div id="ssd-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-microchip"></i>
                    </div>
                    <div>
                        <h2>SSD & NVMe Recovery</h2>
                        <p>Advanced recovery for modern solid state drives</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>Cutting-edge data recovery services for SSDs and NVMe drives. Our specialized equipment and techniques can recover data from failed SSDs, corrupted flash memory, and damaged NVMe drives. We support all major SSD brands including Samsung, Kingston, Crucial, Intel, WD, and SanDisk.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>SSD Types We Recover:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> SATA SSD Recovery</li>
                                <li><i class="fas fa-check"></i> NVMe M.2 Recovery</li>
                                <li><i class="fas fa-check"></i> PCIe SSD Recovery</li>
                                <li><i class="fas fa-check"></i> mSATA SSD Recovery</li>
                                <li><i class="fas fa-check"></i> External SSD Recovery</li>
                                <li><i class="fas fa-check"></i> Flash Memory Recovery</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>SSD Issues We Handle:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> SSD not recognized</li>
                                <li><i class="fas fa-check"></i> Firmware corruption</li>
                                <li><i class="fas fa-check"></i> Controller failure</li>
                                <li><i class="fas fa-check"></i> Bad blocks & wear</li>
                                <li><i class="fas fa-check"></i> Encrypted SSD recovery</li>
                                <li><i class="fas fa-check"></i> Physical damage</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Memory Card & Mobile Recovery -->
            <div id="memory-card-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-memory"></i>
                    </div>
                    <div>
                        <h2>Mobile Memory Card Recovery</h2>
                        <p>Recovery from portable storage and mobile devices</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>We recover data from smartphones, tablets, SD cards, micro SD cards, USB drives, and other portable storage devices. Whether you've accidentally deleted photos, formatted a card, or have a corrupted device, we can help retrieve your precious memories and important files.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>Devices We Recover:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Android Memory Card Recovery</li>
                                <li><i class="fas fa-check"></i> iPhone Memory Card Recovery</li>
                                <li><i class="fas fa-check"></i> SD Card Recovery</li>
                                <li><i class="fas fa-check"></i> Micro SD Recovery</li>
                                <li><i class="fas fa-check"></i> USB Drive Recovery</li>
                                <li><i class="fas fa-check"></i> Pen Drive Recovery</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>Data Types We Recover:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Photos & Videos</li>
                                <li><i class="fas fa-check"></i> Contacts & Messages</li>
                                <li><i class="fas fa-check"></i> Documents & Files</li>
                                <li><i class="fas fa-check"></i> App Data</li>
                                <li><i class="fas fa-check"></i> Audio Files</li>
                                <li><i class="fas fa-check"></i> All File Types</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- RAID & Server Recovery -->
            <div id="raid-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-server"></i>
                    </div>
                    <div>
                        <h2>RAID & Server Recovery</h2>
                        <p>Complex recovery for enterprise storage systems</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>Specialized expertise in recovering data from complex RAID arrays and server systems. We handle all RAID configurations and understand the critical importance of your business data. Our experienced team can rebuild failed RAID arrays and recover data from damaged server systems.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>RAID Configurations:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> RAID 0 (Striping)</li>
                                <li><i class="fas fa-check"></i> RAID 1 (Mirroring)</li>
                                <li><i class="fas fa-check"></i> RAID 5 (Striping with Parity)</li>
                                <li><i class="fas fa-check"></i> RAID 6 (Double Parity)</li>
                                <li><i class="fas fa-check"></i> RAID 10 (Mirrored Stripes)</li>
                                <li><i class="fas fa-check"></i> Custom RAID Configurations</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>Server Types:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Windows Servers</li>
                                <li><i class="fas fa-check"></i> Linux Servers</li>
                                <li><i class="fas fa-check"></i> NAS Systems</li>
                                <li><i class="fas fa-check"></i> SAN Storage</li>
                                <li><i class="fas fa-check"></i> Virtual Machines</li>
                                <li><i class="fas fa-check"></i> Database Recovery</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Specialized Recovery -->
            <div id="specialized-recovery" class="service-detail-card">
                <div class="service-detail-header">
                    <div class="service-detail-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <div>
                        <h2>Specialized Recovery</h2>
                        <p>Advanced techniques for complex data loss scenarios</p>
                    </div>
                </div>
                <div class="service-detail-content">
                    <p>Expert recovery services for the most challenging data loss situations. Our advanced techniques and specialized equipment can handle physical damage, environmental damage, and complex corruption scenarios that other services cannot.</p>

                    <div class="service-features">
                        <div class="feature-column">
                            <h3>Specialized Services:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Physical Damage Recovery</li>
                                <li><i class="fas fa-check"></i> Fire Damaged Drives</li>
                                <li><i class="fas fa-check"></i> Water Damage Recovery</li>
                                <li><i class="fas fa-check"></i> Encrypted Drive Recovery</li>
                                <li><i class="fas fa-check"></i> Forensic Recovery</li>
                                <li><i class="fas fa-check"></i> Clean Room Recovery</li>
                            </ul>
                        </div>
                        <div class="feature-column">
                            <h3>Expert Capabilities:</h3>
                            <ul>
                                <li><i class="fas fa-check"></i> Head Replacement</li>
                                <li><i class="fas fa-check"></i> Platter Extraction</li>
                                <li><i class="fas fa-check"></i> PCB Board Repair</li>
                                <li><i class="fas fa-check"></i> Firmware Recovery</li>
                                <li><i class="fas fa-check"></i> Chip-Off Recovery</li>
                                <li><i class="fas fa-check"></i> Micro-Soldering</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Need Expert Data Recovery Services?</h2>
                <p>Contact us for free consultation and diagnosis. We're here to help 24/7.</p>
                <div class="cta-buttons">
                    <a href="tel:9640524040" class="btn-primary">Call Now: 9640524040</a>
                    <a href="contact.php" class="btn-secondary">Get Free Quote</a>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>